/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.memory;

import emulator.EmulatorException;
import emulator.hardware.debug.BusWatchException;
import emulator.hardware.memory.DebugMemoryBlock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DebugMemoryWriteWatchTest {
    private DebugMemoryBlock memory;

    @Before
    public void setUp() throws Exception {
        this.memory = new DebugMemoryBlock(4096);
        this.memory.enableWriteWatch(512, 767, true);
    }

    @Test(expected=BusWatchException.class)
    public void testWriteWatchInside() throws EmulatorException {
        this.memory.write(512, 170);
    }

    @Test
    public void testWriteWatchOutside() throws EmulatorException {
        this.memory.write(768, 170);
        Assert.assertEquals((long)170L, (long)this.memory.read(768));
    }

    @Test
    public void testWriteWatchIgnoresReads() throws EmulatorException {
        Assert.assertEquals((long)0L, (long)this.memory.read(512));
    }
}

